package data.scripts.campaign.events;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.MissionBoardAPI.MissionAvailabilityAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.ids.Conditions;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.SWPModPlugin;
import data.scripts.campaign.missions.SWP_FamousBountyEvent;
import data.scripts.campaign.missions.SWP_FamousBountyMission;
import org.apache.log4j.Logger;

public class SWP_EventStarter implements EveryFrameScript {

    public static Logger log = Global.getLogger(SWP_EventStarter.class);

    private final IntervalUtil famousBountyTracker;
    private float totalDays = 0f;

    public SWP_EventStarter() {
        famousBountyTracker = new IntervalUtil(10f, 10f);
    }

    @Override
    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        totalDays += days;

        startFamousBountiesIfNeeded(days);
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    private void startFamousBountiesIfNeeded(float days) {
        if (!SWPModPlugin.Module_FamousBounties) {
            return;
        }

        if (SWPModPlugin.Param_LegacyIBB) {
            startFamousBountiesLegacy(days);
            return;
        }

        if (totalDays < 30f) {
            return;
        }

        famousBountyTracker.advance(days);
        if (famousBountyTracker.intervalElapsed()) {
            if (SWP_IBBTracker.getTracker().noStagesAvailable()) {
                return;
            }
            if (Global.getSector().getPlayerFleet() == null) {
                return;
            }

            SWP_FamousBountyMission mission = new SWP_FamousBountyMission(
                    Global.getSector().getHyperspace().createToken(99999, 99999));
            SWP_FamousBountyEvent famousBountyEvent = (SWP_FamousBountyEvent) mission.getPrimedEvent();
            if (famousBountyEvent != null) {
                boolean isAvailable = false;
                for (MarketAPI mkt : Global.getSector().getEconomy().getMarketsCopy()) {
                    if (mkt.getSize() < 3 || mkt.hasCondition(Conditions.DECIVILIZED)
                            || mkt.hasCondition(Conditions.ABANDONED_STATION)) {
                        continue;
                    }
                    if (!SWPModPlugin.isExerelin && !SWP_FamousBountyEvent.IBB_FACTIONS.contains(mkt.getFactionId())) {
                        continue;
                    }

                    int numAtMarket = 0;
                    for (MissionAvailabilityAPI availability : Global.getSector().getMissionBoard().getMissionsCopy()) {
                        if (availability.getMission() instanceof SWP_FamousBountyMission) {
                            for (SectorEntityToken token : mkt.getConnectedEntities()) {
                                if (availability.getAvailableAt().contains(token)) {
                                    numAtMarket++;
                                    break;
                                }
                            }
                        }
                    }

                    int adjust = 0;
                    if (mkt.hasCondition(Conditions.MILITARY_BASE) || mkt.hasCondition("ii_interstellarbazaar")
                            || mkt.hasCondition("ii_military_complex")) {
                        adjust++;
                    }
                    if (mkt.hasCondition(Conditions.HEADQUARTERS)) {
                        adjust++;
                    }
                    if (mkt.hasCondition(Conditions.REGIONAL_CAPITAL)) {
                        adjust++;
                    }
                    if (mkt.hasCondition(Conditions.SPACEPORT) || mkt.hasCondition(Conditions.ORBITAL_STATION)) {
                        adjust++;
                    }
                    if (mkt.hasCondition(Conditions.TRADE_CENTER) || mkt.hasCondition("ii_interstellarbazaar")) {
                        adjust++;
                    }
                    if (mkt.hasCondition(Conditions.FREE_PORT)) {
                        adjust++;
                    }
                    adjust -= numAtMarket;

                    boolean add = false;
                    for (int i = 0; i < mkt.getSize(); i++) {
                        if (mkt.getSize() >= 4 - adjust && Math.random() > 0.35) {
                            add = true;
                            break;
                        } else {
                            adjust--;
                        }
                    }
                    if (!add) {
                        continue;
                    }

                    Global.getSector().getMissionBoard().makeAvailableAt(mission, mkt);
                    isAvailable = true;
                }

                if (!isAvailable) {
                    famousBountyEvent.endEvent(true);
                }
            }
        }
    }

    private void startFamousBountiesLegacy(float days) {
        if (!SWPModPlugin.Module_FamousBounties || !SWPModPlugin.Param_LegacyIBB) {
            return;
        }

        if (totalDays < 30f) {
            return;
        }

        famousBountyTracker.advance(days);
        if (famousBountyTracker.intervalElapsed()) {
            if (SWP_IBBTracker.getTracker().noStagesAvailable()) {
                return;
            }

            SWP_FamousBountyMission mission = new SWP_FamousBountyMission(
                    Global.getSector().getHyperspace().createToken(99999, 99999));
            SWP_FamousBountyEvent famousBountyEvent = (SWP_FamousBountyEvent) mission.getPrimedEvent();
            if (famousBountyEvent != null) {
                boolean isAvailable = false;
                for (MarketAPI mkt : Global.getSector().getEconomy().getMarketsCopy()) {
                    if (mkt.getSize() < 3 || mkt.hasCondition(Conditions.DECIVILIZED)
                            || mkt.hasCondition(Conditions.ABANDONED_STATION)) {
                        continue;
                    }
                    if (!SWPModPlugin.isExerelin && !SWP_FamousBountyEvent.IBB_FACTIONS.contains(mkt.getFactionId())) {
                        continue;
                    }

                    Global.getSector().getMissionBoard().makeAvailableAt(mission, mkt);
                    isAvailable = true;
                }

                if (!isAvailable) {
                    famousBountyEvent.endEvent(true);
                }
            }
        }
    }
}
